<?php
/**
 * =============================================================================
 *  Validazione Campi Fiscali - WHMCS hook
 * =============================================================================
 *
 *  Powered by SoluzioniPhP
 *  Website: https://soluzioniphp.it
 *
 *  Hook Name: Validazione Campi Fiscali
 *  Description: Hook di validazione che rende obbligatori e visibili i campi fiscali (SDI, PEC, Codice Fiscale, VAT) solo per il mercato italiano durante registrazione/checkout.
 *  Non interviene sugli utenti già loggati, evitando blocchi nel processo di acquisto..
 *
 * =============================================================================
 *  LICENSE
 * =============================================================================
 *  Copyright (c) 2026 SoluzioniPhP
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software.
 *
 *  The above copyright notice shall be included in all copies or substantial
 *  portions of the Software.
 *
 * =============================================================================
 *  DISCLAIMER
 * =============================================================================
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 *
 *  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 *  DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 *  OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
 *  USE OR OTHER DEALINGS IN THE SOFTWARE.
 * =============================================================================
 */

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

add_hook('ClientAreaHeadOutput', 1, function ($vars) {

    // Eroghiamo lo script solo dove serve (checkout + dettagli profilo)
    $uri = $_SERVER['REQUEST_URI'] ?? '';
    $isCheckout = (strpos($uri, 'cart.php') !== false && strpos($uri, 'a=checkout') !== false);
    $isDetails  = (strpos($uri, 'clientarea.php') !== false && strpos($uri, 'action=details') !== false);

    // Se utente loggato → nessuna validazione (evita blocco checkout)
    if (!empty($_SESSION['uid'])) {
    return '';
    }

    if (!$isCheckout && !$isDetails) {
        return '';
    }

    // Default country impostato da WHMCS (se disponibile) + fallback
    $defaultCountry = strtoupper(trim($vars['defaultcountry'] ?? 'IT')); // spesso 'IT'
    $defaultCountryIsIT = ($defaultCountry === 'IT') ? 'true' : 'false';

    return <<<HTML
    <script>
    document.addEventListener('DOMContentLoaded', function () {

    // =========================
    // CONFIG CAMPI (ID REALI)
    // =========================
    const SDI_FIELD_ID = 1; // SDI
    const PEC_FIELD_ID = 2; // PEC
    const CF_FIELD_ID  = 3; // Codice Fiscale
    const VAT_FIELD_ID = 4; // VAT / P.IVA (sempre visibile)

    // Default country WHMCS (per UX se country ancora vuoto)
    const DEFAULT_COUNTRY_IS_IT = {$defaultCountryIsIT};

    // =========================
    // HELPERS
    // =========================
    function field(id) {
        return document.querySelector('input[name="customfield[' + id + ']"]');
    }

    function group(el) {
        // Compatibilità: alcuni template wrappano in .form-group, altri diversamente
        return el ? (el.closest('.form-group') || el.closest('.field-container') || el.parentElement) : null;
    }

    function show(el) {
        const g = group(el);
        if (g) g.style.display = '';
    }

    function hide(el) {
        const g = group(el);
        if (g) g.style.display = 'none';
    }

    function setAsterisk(inputEl, on) {
    const g = group(inputEl);
    if (!g) return;

    const label = g.querySelector('label');
    if (!label) return;

    let star = label.querySelector('.req-asterisk');

    if (on) {
        if (!star) {
            star = document.createElement('span');
            star.className = 'req-asterisk';
            star.textContent = ' *';
            label.appendChild(star);
        }
    } else {
        if (star) star.remove();
    }
    }

    function getCountry() {
        const sel = document.querySelector('select[name="country"]');
        return sel ? String(sel.value || '').toUpperCase().trim() : '';
    }

    function isItaly() {
        const c = getCountry();
        // Se country è vuoto (alcuni orderform in prima render), assumiamo IT solo se il default del sistema è IT
        return (c === 'IT') || (!c && DEFAULT_COUNTRY_IS_IT);
    }

    // =========================
    // LOGICA APPLICAZIONE REGOLE
    // =========================
    function applyRules() {
        // Checkout: se l'utente fa login ("Already Registered") WHMCS nasconde il blocco signup.
        // Se lasciamo required su campi nascosti, il browser blocca il submit.
       var signup = document.getElementById('containerNewUserSignup');
       if (signup && (signup.classList.contains('w-hidden') || signup.offsetParent === null)) {

       [SDI_FIELD_ID, PEC_FIELD_ID, CF_FIELD_ID, VAT_FIELD_ID].forEach(function(id){
        var f = field(id);
        if (f) {
            f.required = false;
            f.removeAttribute('required');
            f.setCustomValidity('');
            f.disabled = true; // evita che influenzi submit
        }
      });

      return; // IMPORTANT: non applicare altre regole
      } else {
      // se il blocco signup torna visibile, riabilita i campi
      [SDI_FIELD_ID, PEC_FIELD_ID, CF_FIELD_ID, VAT_FIELD_ID].forEach(function(id){
        var f = field(id);
        if (f) {
            f.disabled = false;
        }
      });
      }
        const PEC = field(PEC_FIELD_ID);
        const SDI = field(SDI_FIELD_ID);
        const CF  = field(CF_FIELD_ID);
        const VAT = field(VAT_FIELD_ID);

        const it = isItaly();

        [PEC, SDI, CF].forEach(function (f) {
        if (!f) return;

        if (it) {
        show(f);
        f.required = true;
        setAsterisk(f, true);
        } else {
        f.required = false;
        f.value = '';
        hide(f);
        setAsterisk(f, false);
        }
       });

      // VAT sempre visibile
       if (VAT) {
       show(VAT);
       VAT.required = true;
       setAsterisk(VAT, true);
       }
    }

    // =========================
    // RETRY (per orderform che renderizzano dopo)
    // =========================
    let tries = 0;
    function tryApply() {
        tries++;
        applyRules();

        // se almeno VAT esiste o abbiamo già tentato abbastanza, ci fermiamo
        const VAT = field(VAT_FIELD_ID);
        if (VAT || tries >= 10) return;

        setTimeout(tryApply, 300);
    }

    tryApply();

    // Aggiorna al cambio country
    const countrySel = document.querySelector('select[name="country"]');
    if (countrySel) {
        countrySel.addEventListener('change', function () {
            // in alcuni temi, i campi vengono rigenerati: ri-applichiamo
            setTimeout(applyRules, 50);
            setTimeout(applyRules, 250);
        });
    }
});
</script>
HTML;
});